package repair;
/*
* Zroje:
* http://forum.zive.cz/viewtopic.php?p=1137501
* http://programujte.com/index.php?akce=diskuze&kam=diskuze&sekce=16-java
* http://www.linuxsoft.cz/article.php?id_article=895
* http://forum.java.sun.com/index.jspa
*/
import java.io.*;
import java.net.*;
import java.util.*;

class Server_T extends Thread{
    private static int port;
    private static int minimum;
    private static int maximum;
    public Server_T(int port, int min, int max){
        this.port = port;
this.minimum=min;
this.maximum=max;
    }
    public static void main(String arg[]){
        if(arg.length==3){
        try{
            port=Integer.valueOf(arg[0]);
            if(port>1024 && port<65536){
                System.out.println("PORT: "+ port);
            }else{
                port=4455;
                System.out.println("ERROR!!!!  Default port: 4455");
            }
        } catch(InputMismatchException a){
            System.out.println("Mismatch Error");
            System.exit(1);
        }
        
        Server_T serv=new Server_T(port, Integer.valueOf(arg[1]),Integer.valueOf(arg[2]));
        serv.start();
    }
    }
    public void run(){
        System.out.println("Server start:"+System.currentTimeMillis());
        ServerSocket serverSocket;
        
        try{
            serverSocket = new ServerSocket(port);
        } catch(IOException a){
            System.out.println("Port already in use...");
            return;
        }
        Apache apache_vlakna = new Apache(this.minimum, this.maximum);
System.out.println("Max threads "+this.maximum);
System.out.println("Min threads "+this.minimum);
        apache_vlakna.start();
        while(true){
            Socket socket;
            try{
                socket = serverSocket.accept();
            } catch(IOException a){
                System.out.println(a.toString());
                continue;
            }
            System.out.println("Client connected");
            apache_vlakna.getControl(socket);
        }
    }
}
class Apache extends Thread{
    public int max=10;
    boolean priznakNovVlak;
    public int min=5;
    SingleApacheThread uselessThread = null; //nevyuzivane vlakno
    private ArrayList<SingleApacheThread> apache_vlakna;
    
    public Apache(int a, int b){
        super("TeePee Apache - Without Windows :-)");
        this.apache_vlakna = new ArrayList<SingleApacheThread>();
this.min=a;
this.max=b;
    }
    
    public void run(){
        while(true){
            
            boolean potrebaNovehoVlakna;
            synchronized(this){
                while(apache_vlakna.size() >= min && apache_vlakna.size() <= max){
                    try {//neni treba nic delat, je dostatecnz pocet vlaken
                        wait();
                    } catch(InterruptedException e) {
                    }
                }
                stabilizace();
                
            }
            
            if (uselessThread != null){ //vice vlaken nez je treba
                System.out.println(" Thread overflow. Regulation started...");
                uselessThread.zrusVlakno();
                System.out.print("  ... Threads are being stabilized ");
            }
            if (priznakNovVlak == true){ // nedostatek vlaken
                System.out.println("    Out of threads. Regulation started... ");
                SingleApacheThread novyApache = new SingleApacheThread(this);
                novyApache.start();
                System.out.print(" ...New Thread: "+novyApache.getName());
                synchronized(this) { // nutna synchronizace
                    apache_vlakna.add(novyApache);
                    notifyAll();
                }
                
                
            }
        }
    }
    
    
        public void getControl(Socket socket){
        SingleApacheThread vlakno;
        synchronized(this) {
            while(apache_vlakna.size() == 0)
                try {
                    System.out.println( "No free threads"); // neni volne vlakno
                    wait();
                } catch (InterruptedException e) {
                    System.out.println(e.toString());
                }
            vlakno = apache_vlakna.remove(apache_vlakna.size() - 1);
            System.out.println( "Thread selected to handle client" +vlakno.getName());
            notifyAll();
        }
        vlakno.zadamObsluhu(socket);
    }
    
    public void stabilizace(){
        if (apache_vlakna.size() > max){
            try{
                sleep(2000);}catch(InterruptedException ff){
                    ff.printStackTrace();}
            
            
            uselessThread = apache_vlakna.remove(apache_vlakna.size()-1);} else{
            uselessThread = null;}
        
        if (apache_vlakna.size() < min){
            priznakNovVlak = true;} else{
            priznakNovVlak = false;}
    }
    
    
    public synchronized void volneVlakno(SingleApacheThread vlakno){
        apache_vlakna.add(vlakno);
        System.out.println(vlakno.getName()+" has been discharged");
        notifyAll();
    }
    

    
}
class SingleApacheThread extends Thread{
    private boolean konecVlakna;
    private static int cisloVlakna = 1;
    private Apache teePee;
    private byte[] buffer = new byte[128];
    private Socket socket;
    private DataInputStream data_in;
    private DataOutputStream data_out;
    
    public synchronized void zadamObsluhu(Socket socket){
        this.socket = socket;
        notifyAll();
    }
    
    
    public SingleApacheThread(Apache teePee){
        super();
        cisloVlakna++;
        this.teePee = teePee;
        this.konecVlakna = false;
    }
    public void run(){
        System.out.println("Control Thread starts...");
        while(true){
            Socket tempSocket;
            synchronized(this){
                while(!konecVlakna && socket == null){
                    try {
                        System.out.println("Thread "+cisloVlakna+" waiting for client....");
                        wait();
                    } catch(InterruptedException e) {
                    }
                }
                if (konecVlakna) {
                    System.out.println("Thread "+cisloVlakna+" Game Over");
                    return;
                }
                tempSocket = socket;
                socket = null;
            }
            System.out.println("Accepting client's request");
            this.handle(tempSocket);
            teePee.volneVlakno(this);
        }
    }
    private void handle(Socket socketicek){              
                    try {
            data_in = new DataInputStream((socketicek.getInputStream()));
            data_out = new DataOutputStream((socketicek.getOutputStream()));
        } catch(IOException ex){
            
            System.out.println(this.getName()+"Connection error");
            try {
                socketicek.close(); 
            } catch(IOException qq){qq.printStackTrace();
            return;
            }
            
        }
        try {
            while (true) {
                String incomingFile=data_in.readUTF();
                if (incomingFile.equals("KONEC")){
                    System.out.println(this.getName()+" "+cisloVlakna+"  End of file transfer");
                    break;}
                prijmi();
            }
        } catch(IOException e){
            e.toString() ;
            return ;
        } finally {
            try{
                socketicek.close();}catch(IOException aa){aa.printStackTrace();}
        }
    }
        public synchronized void zrusVlakno(){
        konecVlakna = true;
        notifyAll();
    }
    public void prijmi() throws IOException{
        String soubor_nazev=data_in.readUTF();
        System.out.println("Incoming file "+soubor_nazev);
        File soubor=new File(System.currentTimeMillis()+"__"+soubor_nazev);
        FileOutputStream souborOut = new FileOutputStream(soubor);
        long v_temp=data_in.readLong() ;
        System.out.println("File size "+v_temp);
        int length;
        long k=v_temp;
        int pocetik=0;
        try{
            int tempvstup=0;
            while (v_temp>=0) { // dokad je zbyvajici velikost prichoziho souboru vetsi nebo rovna 0 - cili jeste se neulozil cely soubor
                if(v_temp>=128){// dokad je zbyvajici velikost prichoziho souboru vetsi nebo rovna bufferu
                    length=data_in.read(buffer);
                    souborOut.write(buffer,0, length);
                    if(pocetik==500){//pravidelny vypis
                        System.out.println(this.getName()+" Zbyva ulozit 1               "+v_temp);
                        pocetik=0;
                    }
                    v_temp=v_temp-128;
                    pocetik++;
                }else{// zbyvajici velikost je mensi nez velikost bufferu, je treba udelat mensi buffer, abych ulozil do souboru jen data z daneho prichoziho souboru, ne z druheho souboru od stejneho klienta
                    byte buffer3[]=new byte[(int)v_temp];
                    length=data_in.read(buffer3);
                    souborOut.write(buffer3,0,length);
                    System.out.println("Dopsano    "+ v_temp);
                    if(pocetik==500){
                        System.out.println(" Zbyva ulozit 2                           "+v_temp);
                        pocetik=0;
                    }
                    v_temp=v_temp-128;
                    pocetik++;
                }
                try{sleep(2);}catch(Exception ff){}
            }
            
            System.out.println("Recieved File"+soubor.getName());
        }catch(IOException aq){
            System.out.println("SAT radke 186  "+aq.toString());
        }
        try{
            souborOut.close();//Zavri vstup do souboru
            try{
                data_out.writeChar('G'); // posli klientovi potvrzeni o uspesnem prijeti souboru
                System.out.println("Confirmation has sent");} catch(IOException sds){
                    System.out.println("sat 199  "+sds.toString());
                }
            System.out.println("File Closed");
        } catch(IOException qwe){
            System.out.println("SSAT 184 "+qwe.toString());
        }
    }
        
}