package DatoveTridy;
import GrafickeTridy.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
       
/**
 *
 * @author Vladimr ha
 */
public class DatButton{
    public  int rozmer=15;
    private int vlastnik;

    private int umisteniX;
    private int umisteniY;
    private boolean pouzito;
    public int vysledek1;
    public int vysledek2;
    public int vysledek3;
    public int vysledek4;
    
  /** Vytvori objekt tridy DatButton. Tento objekt predstavuje jedno herni tlacitko ve hre. Promenne tridy jsou: 
     * @param y ktery hrac vlastni tlacitko, cili na nej kliknul a udelal jsou znaku X/O   
     * @param z umisteniY na kterem sloupci je dany DatButton v poli DatButtonu
   * @param x umisteniX na kterem radku je dany DatButton v poli DatButtonu
     *  @param s boolean, znaci, jestli bylo na dany DatButton jiz zahrano 
     */
    public DatButton(int y, int x, int z, boolean s) {
        this.vlastnik=y;
        this.umisteniY=z;
        this.umisteniX=x;
        this.pouzito=s;
    }
   /** Zjisti, na kolikatem miste je dany objekt typu Button v dvourozmernem poli Button. Prvni Button na pozici [0][0] je 0.
     * @return <code>y </code> - poradi prvku v poli
     */
    public int getPoradiButton(){
        int j=this.getUmisteniX();
        int k=this.getUmisteniY();
        int y=(j*rozmer)+k;
        return y;
    }
    
      /** Vrati cislo vlastnika daneho objektu typu Button
     * @return <code>this.vlastnik</code>
     */
    public int getVlastnik(){
        return this.vlastnik;
    }
         /** Vrati cislo radku pole, na kterem je  dany objektu typu Button
     * @return <code>this.umisteniX</code>
     */
    public int getUmisteniX(){
        return this.umisteniX;
    }
         /** Vrati cislo sloupce pole, na kterem je  dany objektu typu Button
     * @return <code>this.umisteniY</code>
     */
    public int getUmisteniY(){
        return this.umisteniY;
    }

   /** Nastavi vlastnika pro objekt Button
     * @param y  hodnota typu integer udavajici vlastnika tlacitka
     */
    public void setVlastnik(int y){
        this.vlastnik=y;
    }
 /**  Otestuje hodnotu promenne pouzito
     * @return <code>this.pouzito</code>
     */
    public boolean getPouzito(){
        return this.pouzito;
    }
       /** Nastavi DatButton na pouzity
     * @param b hodnota true / false
     */
    /** Nastavi dany Button na pouzity  */
    public void setPouzito(boolean g){
        this.pouzito=g;
    }
 /** Vykona se pri stisku tlacitka. V zavislosti na parametru a typu integer nastavi u DatButton jeho promenne na prislusne hodnoty
     * @param a integer a reprezentuje hrace, ktery tahnul
     */
    public void tahnuto(int a)  throws MalformedURLException{ //protoze ji vyhazuje i potomek teto tridy - GrafickyButton, tak aby sla jednoduse prepsat v potomkovi
        if(a==0){
            this.setVlastnik(0);
            this.setPouzito(true);
          
        } else{
            this.setVlastnik(1);
            this.setPouzito(true);    
        }
    }
    /** Vyhodnoti tah. Metoda vyhodnoceni pracuje s objekty tridy Vyhodnoceni, ktere vraci metody <code>vyhodnoceniRadku, vyhodnoceniSloupce, vyhodnoceniDiagonaly1
     *   a vyhodnoceniDiagonaly2</code>. Ty vraceji tyto objekty s parametry, ktere zavisi na uspesnosti tahu hrace (jestli vyhral). Je - li pak v nejakem vyhodnoceni1-4
     *  nastavena promenna vitezstvi na true, program reaguje a metoda vyhodnoceni vrati true, jinak false.
     * @param aktual cislo hrace, typ integer
     * @param pole 2-rozmerne pole prvku typu DatButton
     *@return  vraci, zda byl hracuv tah vitezny
     */
    public boolean vyhodnoceni(int aktual,DatButton[][] pole){
        Vyhodnoceni vyhodnoceni1=this.vyhodnoceniRadku(aktual,  pole);
        
        if(vyhodnoceni1.getVitezstvi()){
            return true;
        }
        Vyhodnoceni vyhodnoceni2=this.vyhodnoceniSloupce(aktual, pole);
        
        if(vyhodnoceni2.getVitezstvi()){
            return true;
        }
        Vyhodnoceni vyhodnoceni3=this.vyhodnoceniDiagonaly1(aktual,pole);
        
        if(vyhodnoceni3.getVitezstvi()){
            return true;
        }
        Vyhodnoceni vyhodnoceni4=this.vyhodnoceniDiagonaly2(aktual,pole);
        
        if(vyhodnoceni4.getVitezstvi()){
            return true;
        }
        return false;
    }
 /** Metoda vyhodnoceniRadku ma jako parametry aktual (typu integer) a pole (dvourozmerne pole typu DatButton) a vraci instanci tridy Vyhodnoceni.
     * Parametr aktual symbolizuje cislo hrace, jehoz tah se prave zpracovava. Parametr pole [][] pak je pole typu DatButton, na kterem se hraje. Princip vyhdnocovani
     * tahu je velmi podobny pro vsechny metody vyhodnoceni/Radku/Sloupce/Diagonaly1/Diagonaly2. Vzdy je treba zjistit, kolik objektu DatButton je v poli okolo
     * stisknuteho objektu tridy DatButton. Tyto pocty jsou reprezentovany pomoci promennych typu integer hraniceLeva a hranicePrava. Protoze piskvorky se hraji alespon na 5
     * poli stejnych, nema cenu, aby byly tyto promenne vetsi nez 4. Pote je vytvoreno pomocne pole typu DatButton nazvane polePom, do ktereho se ukladaji instance tridy
     * DatButton z pole (parametr metody). Posledni dva for - cykly pak pocitaji, kolik je instanci tridy DatButton se stejnym vlastnikem (tedy znakem X/O) v souvisle rade nalevo a napravo
     * od stisknuteho tlacitka. Je-li nektere dalsi tlacitko v poliPom jineho vlastnika - hrace, dojde k preruseni cyklu. Je - li stejneho hrace, pak se zvysi hodnota
     * promenne shoda (typu integer) o jeden. Je - li pak tato promenna vetsi nez 4, hrac vyhral a vytvori se prislusny objekt typu Vyhodnoceni
     * @param aktual cislo aktualniho hrace
     * @param pole  pole prvku typu DatButton, reprezentuji hraci plochu
     *@return Vyhodnoceni novou instanci tridy Vyhodnoceni
     */
    public Vyhodnoceni vyhodnoceniRadku(int aktual,DatButton[][] pole){
        //porovnani v radku smerem doleva
        int pozice=this.getUmisteniY();
        int horizontPozice=this.getUmisteniX();
        int indexhrace=aktual;
        int hranicePrava=(rozmer-1)-pozice;
        // kolik prvku-tlacitek je pred nebo za zmacknutym tlacitkem na hraci plose
        int hraniceLeva=pozice;
        if(hraniceLeva>4)hraniceLeva=4;
        if(hranicePrava>4)hranicePrava=4;
        int celkem=hraniceLeva+hranicePrava+1;
        int count=0;
        int tempLeva=pozice-hraniceLeva;
// pomocne pole tlacitek, ktere budu porovnat v radce
        DatButton [] polePom=new DatButton[celkem];
        for(int h=0;h<hraniceLeva;h++ ){
            polePom[h]=pole[horizontPozice][tempLeva];
            tempLeva++;
            count++;
        }
        polePom[hraniceLeva]=this;
        count++;
        for(int w=pozice+1;w<pozice+hranicePrava+1;w++){
            polePom[count]=pole[horizontPozice][w];
            count++;
            
        }
// ted mam jedno pole(=cast radku z hraci plochy) na porovnani
        int d=1;
        int shoda=1;
        for(int z=hraniceLeva-d;z>=0;z--){
            if(indexhrace==polePom[z].getVlastnik()){
                shoda++;
                d++;
            } else{break;}}
        int g=1;
        for(int k=hraniceLeva+g;k<celkem;k++){
            if(indexhrace==polePom[k].getVlastnik()){
                shoda++;
                g++;
            } else{break;}
        }
        vysledek1=shoda;
        if(shoda>4){
            return new Vyhodnoceni(true, vysledek1,aktual);
        }
        shoda=1;
        return new Vyhodnoceni(false, vysledek1,aktual);
    }
    /** Metoda vyhodnoceniSloupce ma jako parametry aktual (typu integer) a pole (dvourozmerne pole typu DatButton) a vraci instanci tridy Vyhodnoceni.
     * Parametr aktual symbolizuje cislo hrace, jehoz tah se prave zpracovava. Parametr pole [][] pak je pole typu DatButton, na kterem se hraje. Vzdy je treba zjistit, kolik objektu DatButton je v poli okolo
     * stisknuteho objektu tridy DatButton. Tyto pocty jsou reprezentovany pomoci promennych typu integer hraniceDolni a hraniceHorni. Protoze piskvorky se hraji alespon na 5
     * poli stejnych, nema cenu, aby byly tyto promenne vetsi nez 4. Pote je vytvoreno pomocne pole typu DatButton nazvane polePom2, do ktereho se ukladaji instance tridy
     * DatButton z pole (parametr metody). Posledni dva for - cykly pak pocitaji, kolik je instanci tridy DatButton se stejnym vlastnikem (tedy znakem X/O) v souvislem sloupci nahore a dole
     * od stisknuteho tlacitka. Je-li nektere dalsi tlacitko v poliPom2 jineho vlastnika - hrace, dojde k preruseni cyklu. Je - li stejneho hrace, pak se zvysi hodnota
     * promenne shoda (typu integer) o jeden. Je - li pak tato promenna vetsi nez 4, hrac vyhral a vytvori se prislusny objekt typu Vyhodnoceni
     * @param aktual cislo aktualniho hrace
     * @param pole pole prvku typu DatButton, reprezentuji hraci plochu
     *@return Vyhodnoceni novou instanci tridy Vyhodnoceni
     */
    public Vyhodnoceni vyhodnoceniSloupce(int aktual,DatButton[][] pole){
        int pozice=this.getUmisteniY();
        int horizontPozice=this.getUmisteniX();
        
        int indexhrace=aktual;
        int hraniceDolni=(rozmer-1)-horizontPozice;
        int hraniceHorni=horizontPozice;
        if(hraniceHorni>4)hraniceHorni=4;
        if(hraniceDolni>4)hraniceDolni=4;
        int celkem=hraniceHorni+hraniceDolni+1;
        int count=0;
        DatButton [] polePom2=new DatButton[celkem];
        int tempHorni=horizontPozice-hraniceHorni;
        
        for(int h=0;h<hraniceHorni;h++ ){
            polePom2[h]=pole[tempHorni][pozice];//error 3
            count++;
            
            tempHorni++;
            
        }
        polePom2[hraniceHorni]=this;
        count++;
        for(int w=horizontPozice+1;w<horizontPozice+hraniceDolni+1;w++){
            polePom2[count]=pole[w][pozice];
            count++;
        }
        int d=1;
        int shoda=1;
        for(int z=hraniceHorni-d;z>=0;z--){
            if(indexhrace==polePom2[z].getVlastnik()){
                shoda++;
                d++;
            } else{break;}
        }
        int g=1;
        for(int k=hraniceHorni+g;k<celkem;k++){
            if(indexhrace==polePom2[k].getVlastnik()){
                shoda++;
                g++;
            } else{break;}
        }
        vysledek2=shoda;
        if(shoda>4){
            return new Vyhodnoceni(true, vysledek2, aktual);
        }
        
        shoda=1;
        return new Vyhodnoceni(false, vysledek2,aktual);
    }
    /** Metoda vyhodnoceniDiagonaly1 ma jako parametry aktual (typu integer) a pole (dvourozmerne pole typu DatButton) a vraci instanci tridy Vyhodnoceni.
     * Parametr aktual symbolizuje cislo hrace, jehoz tah se prave zpracovava. Parametr pole [][] pak je pole typu DatButton, na kterem se hraje. Vzdy je treba zjistit, kolik objektu DatButton je v poli okolo
     * stisknuteho objektu tridy DatButton. Tyto pocty jsou reprezentovany pomoci promennych typu integer horniHranice a dolniHranice. Protoze piskvorky se hraji alespon na 5
     * poli stejnych, nema cenu, aby byly tyto promenne vetsi nez 4. Pote je vytvoreno pomocne pole typu DatButton nazvane polePom3, do ktereho se ukladaji instance tridy
     * DatButton z pole (parametr metody). Posledni dva for - cykly pak pocitaji, kolik je instanci tridy DatButton se stejnym vlastnikem (tedy znakem X/O) v souvisle diagonale od leveho horniho konce 
      * do praveho dolniho konce od stisknuteho tlacitka. Je-li nektere dalsi tlacitko v poliPom3 jineho vlastnika - hrace, dojde k preruseni cyklu. Je - li stejneho hrace, pak se zvysi hodnota
     * promenne shoda (typu integer) o jeden. Je - li pak tato promenna vetsi nez 4, hrac vyhral a vytvori se prislusny objekt typu Vyhodnoceni
     * @param aktual cislo aktualniho hrace
     * @param pole pole prvku typu DatButton, reprezentuji hraci plochu
     *@return Vyhodnoceni novou instanci tridy Vyhodnoceni
     */
    public Vyhodnoceni vyhodnoceniDiagonaly1(int aktual,DatButton[][] pole){
        int pozice=this.getUmisteniY();
        int horizontPozice=this.getUmisteniX();
        int pozice2=(rozmer-1)-pozice;
        int horizontPozice2=(rozmer-1)-horizontPozice;
        
        int horniHranice;
        // pocet prvku
        if(pozice>horizontPozice){ horniHranice=horizontPozice;} else{horniHranice=pozice;}
        
        int dolniHranice;
        if(pozice2>horizontPozice2) {dolniHranice=horizontPozice2;} else{ dolniHranice=pozice2;}
        if(dolniHranice>4)dolniHranice=4;
        if(horniHranice>4)horniHranice=4;
        
        int indexhrace=aktual;
        int celkem=dolniHranice+horniHranice+1;
        DatButton [] polePom3=new DatButton[celkem];
        int tempHorni=horizontPozice-horniHranice;
        int tempDolni=pozice-horniHranice;
        int count=0;
        int temp1=pozice-horniHranice;
        int temp2=horizontPozice-horniHranice;
        for(int j=0;j<horniHranice;j++){
            polePom3[j]=pole[temp2][temp1];
            tempHorni++;
            tempDolni++;
            count++;
            temp2++;
            temp1++;
        }
        polePom3[horniHranice]=this;
        count++;
        int qw=1;
        for(int p=horniHranice+1;p<celkem;p++){
            polePom3[count]=pole[horizontPozice+qw][pozice+qw];
            count++;
            qw++;
        }
        int d=1;
        int shoda=1;
        for(int z=horniHranice-d;z>=0;z--){
            if(indexhrace==polePom3[z].getVlastnik()){
                shoda++;
                d++;
            } else{break;}}
        int g=1;
        for(int k=horniHranice+g;k<celkem;k++){
            if(indexhrace==polePom3[k].getVlastnik()){
                shoda++;
                g++;
            } else{break;}
        }
        vysledek3=shoda;
        if(shoda>4){
            return new Vyhodnoceni(true, vysledek3, aktual);
        }
        
        shoda=1;
        return new Vyhodnoceni(false, vysledek3, aktual);
    }
     /** Metoda vyhodnoceniDiagonaly2 ma jako parametry aktual (typu integer) a pole (dvourozmerne pole typu DatButton) a vraci instanci tridy Vyhodnoceni.
     * Parametr aktual symbolizuje cislo hrace, jehoz tah se prave zpracovava. Parametr pole [][] pak je pole typu DatButton, na kterem se hraje. Vzdy je treba zjistit, kolik objektu DatButton je v poli okolo
     * stisknuteho objektu tridy DatButton. Tyto pocty jsou reprezentovany pomoci promennych typu integer horniHranice a dolniHranice. Protoze piskvorky se hraji alespon na 5
     * poli stejnych, nema cenu, aby byly tyto promenne vetsi nez 4. Pote je vytvoreno pomocne pole typu DatButton nazvane polePom4, do ktereho se ukladaji instance tridy
     * DatButton z pole (parametr metody). Posledni dva for - cykly pak pocitaji, kolik je instanci tridy DatButton se stejnym vlastnikem (tedy znakem X/O) v souvisle diagonale od praveho horniho konce 
      * do leveho dolniho konce od stisknuteho tlacitka. Je-li nektere dalsi tlacitko v poliPom4 jineho vlastnika - hrace, dojde k preruseni cyklu. Je - li stejneho hrace, pak se zvysi hodnota
     * promenne shoda (typu integer) o jeden. Je - li pak tato promenna vetsi nez 4, hrac vyhral a vytvori se prislusny objekt typu Vyhodnoceni
     * @param aktual cislo aktualniho hrace
     * @param pole pole prvku typu DatButton, reprezentuji hraci plochu
     *@return Vyhodnoceni novou instanci tridy Vyhodnoceni
     */
    public Vyhodnoceni vyhodnoceniDiagonaly2(int aktual,DatButton[][] pole){
        int pozice=this.getUmisteniY();
        int horizontPozice=this.getUmisteniX();
        int pozice2=(rozmer-1)-pozice;
        int horizontPozice2=(rozmer-1)-horizontPozice;
        
        int horniHranice;
        // pocet prvku
        if(horizontPozice>pozice2){ horniHranice=pozice2;} else {
            horniHranice=horizontPozice;}
        
        int dolniHranice;
        if(pozice>horizontPozice2) {dolniHranice=horizontPozice2;} else{ dolniHranice=pozice;}
        if(dolniHranice>4)dolniHranice=4;
        if(horniHranice>4)horniHranice=4;
        
        
        int indexhrace=aktual;
        int celkem=dolniHranice+horniHranice+1;
        DatButton [] polePom4=new DatButton[celkem];
        int count=0;
        int temp1=horizontPozice+dolniHranice; //radek
        int temp2=pozice-dolniHranice; // sloupec
        // nejspodnejsi bod
        for(int j=0;j<dolniHranice;j++){
            polePom4[j]=pole[temp1][temp2];
            count++;
            temp1--;
            temp2++;
        }
        //naplneno po dane tlacitko od tlacitka dolniHranice
        polePom4[count]=this;
        count++;
        int temp3=horizontPozice-1; // radek
        int temp4=pozice+1; //sloupec
        for(int p=0;p<horniHranice;p++){
            polePom4[count]=pole[temp3][temp4];
            count++;
            temp3--;
            temp4++;
        }
        int d=1;
        int shoda=1;
        for(int z=dolniHranice-1;z>=0;z--){
            if(indexhrace==polePom4[z].getVlastnik()){
                shoda++;
                
            } else{break;}}
        
        for(int k=dolniHranice+1;k<celkem;k++){
            if(indexhrace==polePom4[k].getVlastnik()){
                shoda++;
            } else{break;}
        }
        vysledek4=shoda;
        if(shoda>4){
            return new Vyhodnoceni(true, vysledek4, aktual);
        }
        
        shoda=1;
        return new Vyhodnoceni(false, vysledek4, aktual);
    }
 /** Zjisti, zda nastala remiza, cili kazdy prvek v poli Buttonu (parametr funkce) ma nastaveno pouzito na true.     
     * @param pole Dvourozmerne pole objektu tridy DatButton
     * @return zda nastala remiza
     */
        public boolean remiza(DatButton[][] pole){
        int pocetPouzitychPoli=0;
        for(int j=0;j<rozmer;j++){
            for(int g=0;g<rozmer;g++){
                if(pole[j][g].getPouzito()){
                    pocetPouzitychPoli++;
                }
            }
        }
        if(pocetPouzitychPoli==(rozmer*rozmer)){
            return true;
        }
        return false;
    }
   /** Nastavi vsechny instance tridy Button na puvodni hodnoty 
     * @param pole Dvourozmerne pole objektu tridy DatButton
     */
    public void reset(DatButton[][] pole){
               for(int i=0;i<rozmer;i++){
                for(int y=0;y<rozmer;y++){
                   pole[i][y].setPouzito(false);
             pole[i][y].setVlastnik(3);
                }
            }
       
    }
}
