/*
 * ClientP.java
 * Created on 3. kvten 2007, 11:57
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package GrafickeTridy;

import DatoveTridy.Vyhodnoceni;
import Sit.*;
import javax.swing.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.awt.event.*;

/**
 * @author Vladimr ha
 */
public class Client extends JApplet implements Runnable {
    private GrafickyButton currentButton;
    private Socket socket;
    private JButton ok2;
    private DataInputStream vstup;
    private DataOutputStream vystup;
    private int aktualHrac; // urcuje, ktery hrac je na rade
    private boolean hraProtiPC;
    int rozmer=15;
    private boolean ready=false;
    public boolean priznakOdpojeni=false;
    public final GrafickyButton[][] pole=new GrafickyButton[rozmer][rozmer];
    public int v1;
    public int v2;
    public int v3;
    public int v4;
    private ServerP s;
    private int port;
    private String ipAdresa;
    private boolean jizPripojen;
    private boolean priznakVlakna=false;
    // grafika
    
    private javax.swing.JDialog jDialog2;
    private JButton novaHra;
    private JTextField text1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    public javax.swing.JTextPane jTextPane1;
    private JButton connect;
    private JButton join;
    private boolean typHrace=true;
    // true je server-hrac
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextPane popisek;
    private JButton ok;
    private JButton ok3;
    private JButton ok4;
    private  JButton uvolniPort;
    private JTextField ip1;
    private JTextField ip2;
    private JTextField ip3;
    private JTextField ip4;
    
    private JButton info;
    private int cisloHrace;
    private boolean priznakServeru=false;
    public Thread vystupniVlakno;
    /**
     * inicialize grafickych prvku
     */
    
    public void  init() {
        ok2=new JButton();
        ok2.setText("OK");
        ok2.setVisible(false);
        ok2.setPreferredSize(new Dimension(60,25));
        jScrollPane2 = new javax.swing.JScrollPane();
        popisek = new javax.swing.JTextPane();
        jScrollPane2.setViewportView(popisek);
        jDialog2 = new javax.swing.JDialog();
        jDialog2.setLayout(new java.awt.BorderLayout());
        popisek.setFocusable(false);
        text1= new javax.swing.JTextField();
        ok=new JButton();
        ok.setText("OK");
        ok.setVisible(true);
        
        ok3=new JButton();
        ok3.setText("OK");
        ok3.setVisible(false);
        ok4=new JButton();
        ok4.setText("OK");
        ok4.setVisible(false);
        
        jDialog2.setMinimumSize(new Dimension(300,180));
        jDialog2.setPreferredSize(new Dimension(300,180));
        
        novaHra=new JButton();
        novaHra.setText("Nova hra");
        novaHra.setVisible(true);
        novaHra.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                novaHra();
            }
        });
        info=new JButton();
        info.setText("Informace");
        info.setVisible(true);
        info.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                informace();
                text1.setVisible(false);
                ok.setVisible(false);
            }
        });
        ok2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jDialog2.setVisible(false);
                popisek.setText("");
                jDialog2.setTitle("");
                ok2.setVisible(false);
                popisek.setMinimumSize(new java.awt.Dimension(280, 60));
                popisek.setPreferredSize(new java.awt.Dimension(280, 60));
                jDialog2.setMinimumSize(new Dimension(300,180));
                jDialog2.setPreferredSize(new Dimension(300,180));
                jDialog2.setMaximumSize(new Dimension(300,180));
                popisek.setMinimumSize(new java.awt.Dimension(280, 60));
                popisek.setPreferredSize(new java.awt.Dimension(280, 60));
            }
        });
        jPanel3 = new javax.swing.JPanel();
        jPanel3.setLayout(new java.awt.FlowLayout());
        jPanel1 = new javax.swing.JPanel();
        jPanel1.setLayout(new java.awt.FlowLayout());
        jPanel4 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        setMinimumSize(new java.awt.Dimension(800,800));
        jDialog2.add(jPanel3, java.awt.BorderLayout.NORTH);
        jDialog2.add(jPanel1, java.awt.BorderLayout.CENTER);
        join=new javax.swing.JButton();
        join.setText("Pripoj");
        join.setVisible(true);
        connect=new javax.swing.JButton();
        connect.setText("Vytvorit");
        connect.setVisible(true);
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextPane1 = new javax.swing.JTextPane();
        jScrollPane1.setViewportView(jTextPane1);
        jTextPane1.setMinimumSize(new java.awt.Dimension(140, 100));
        jTextPane1.setPreferredSize(new java.awt.Dimension(140, 100));
        jPanel4.setMaximumSize(new java.awt.Dimension(150,100));
        jPanel4.setMinimumSize(new java.awt.Dimension(150,100));
        jPanel4.setPreferredSize(new java.awt.Dimension(150, 100));
        getContentPane().add(jPanel4, java.awt.BorderLayout.EAST);
        jPanel4.setLayout(new java.awt.FlowLayout());
        jPanel4.add(jTextPane1);
        jPanel2.setLayout(new java.awt.GridLayout(rozmer, rozmer));
        jPanel4.add(connect);
        jPanel4.add(join);
        jPanel4.add(novaHra);
        jPanel4.add(info);
        jPanel2.setMinimumSize(new java.awt.Dimension(550, 550));
        getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);
        
        connect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                typHrace=true;
                
                vytvoritDialog();
            }
        });
        ok.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent f) {
                kontrolaPortu();
                
            }
        });
        
        join.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent h) {
                pripojitDialog();
                typHrace=false;
            }
        });
        
        ok3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent g) {
                vytvoritPripojit();
            }
        });
        ok4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent g) {
                pripojitDialog2();
            }
        });
        for(int a=0;a<rozmer;a++){
            for(int t=0;t<rozmer;t++){
                final GrafickyButton q=new GrafickyButton(3,a,t,false, this.getCodeBase());
                pole[a][t]=q;
                
                q.getButton().addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent e) {
                        if(!priznakOdpojeni){
                            currentButton=q;
                            odeslatTah(q.getPoradiButton());
                        }}
                });
                ((JButton)q.getButton()).setMinimumSize(new Dimension(23,23));
                ((JButton)q.getButton()).setMaximumSize(new Dimension(23,23));
                ((JButton)q.getButton()).setSize(23,23);
                jPanel2.add(q.getButton());
            }
        }
        join.setToolTipText("Pripojit se ke hre");
        connect.setToolTipText("Vytvorit novou hru a cekat na protivnika");
        jPanel3.add(popisek);
        ip1=new JTextField();
        ip2=new JTextField();
        ip3=new JTextField();
        ip4=new JTextField();
        jPanel1.add(ok3);
        jPanel1.add(ok2);
        jPanel1.add(ip1);
        jPanel1.add(ip2);
        jPanel1.add(ip3);
        jPanel1.add(ip4);
        ip1.setPreferredSize(new Dimension(40,20));
        ip1.setMinimumSize(new Dimension(40,20));
        ip1.setMaximumSize(new Dimension(40,20));
        ip2.setPreferredSize(new Dimension(40,20));
        ip2.setMinimumSize(new Dimension(40,20));
        ip2.setMaximumSize(new Dimension(40,20));
        ip3.setPreferredSize(new Dimension(40,20));
        ip3.setMinimumSize(new Dimension(40,20));
        ip3.setMaximumSize(new Dimension(40,20));
        ip4.setPreferredSize(new Dimension(40,20));
        ip4.setMinimumSize(new Dimension(40,20));
        ip4.setMaximumSize(new Dimension(40,20));
        ip1.setVisible(false);
        ip2.setVisible(false);
        ip3.setVisible(false);
        ip4.setVisible(false);
        
        jPanel1.add(ok);
        ip1.setText("127");
        ip2.setText("0");
        ip3.setText("0");
        ip4.setText("1");
        text1.setVisible(false);
        ok.setVisible(false);
        
        popisek.setMinimumSize(new java.awt.Dimension(280, 60));
        popisek.setPreferredSize(new java.awt.Dimension(280, 60));
        novaHra.setEnabled(false);
        this.setPreferredSize(new Dimension(600,400));
        this.setSize(600,400);
        join.setPreferredSize(new Dimension(100,25));
        connect.setPreferredSize(new Dimension(100,25));
        novaHra.setPreferredSize(new Dimension(100,25));
        ok.setPreferredSize(new Dimension(60,25));
        ok3.setPreferredSize(new Dimension(60,25));
        ok4.setPreferredSize(new Dimension(60,25));
        jTextPane1.setFocusable(false);
        jTextPane1.setToolTipText("Systemove zpravy");
        novaHra.setToolTipText("Nova hra se stejnym hracem");
        info.setPreferredSize(new Dimension(100,25));
        
    }
    /**
     *Zacne novou hru. V hracove tahu je mozne se vzdat, pak se da vedet i protihraci a na tahu je hrac, ktery se nevzdal
     */
    
    public void novaHra(){
        try{
            odeslatTah(rozmer*rozmer+1);
            pole[0][0].reset(pole);
            priznakOdpojeni=false;
        } catch(MalformedURLException s){
            popisek.setText("Obrazky nenalezeny");
        }
    }
    public void informace(){
        ip1.setVisible(false);
        ip2.setVisible(false);
        ip3.setVisible(false);
        ip4.setVisible(false);
        jDialog2.setVisible(true);
        jDialog2.setMinimumSize(new Dimension(350,300));
        jDialog2.setTitle("Napoveda");
        
        jDialog2.setPreferredSize(new Dimension(350,300));
        popisek.setPreferredSize(new Dimension(300,150));
        popisek.setText("Vitej ve hre piskvorky. Pro hru po siti stiskni Vytvorit (zakladas-li hru) nebo Pripojit (chces-li se pripojit k existujici hre). Muze se stat, ze dojde k" +
                " chybe v sitove komunikaci, kterou nelze predem predpokladat. V tom pripade je durazne doporucen restart aplikace (klavesa F5) popripade opetovne otevreni " +
                " stranky s appletem. Zaroven si zkontrolujte nastaveni firewallu.");
        ok2.setVisible(true);
        
    }
    /**
     * Vytvori novy socket. Je treba zadat IP adresu a cislo portu. Nastavi vstupni a vystupni streamy
     */
    public void pripojitDialog2(){
        priznakOdpojeni=false;
        
        jDialog2.setTitle("Port "+port);
        ok4.setVisible(false);
        ipAdresa=ip1.getText()+"."+ip2.getText()+"."+ip3.getText()+"."+ip4.getText();
        try{
            pole[0][0].reset(pole);
            
        } catch (MalformedURLException e) {
            jTextPane1.setText("CHYBA: Obrazky nenalezeny.");
        }
        text1.setVisible(true);
        
        if(jizPripojen){
            try{
                
                socket.close();
            } catch(IOException a){
                
                jTextPane1.setText("Chyba spojen, nelze uzavt stvajc spojen");
            }
        }
        
        try {
            socket = new Socket(ipAdresa, port);
            text1.setVisible(false);
            vstup = new DataInputStream(socket.getInputStream());
            vystup = new DataOutputStream(socket.getOutputStream());
            vystupniVlakno = new Thread(this);
            vystupniVlakno.setDaemon(true);
            vystupniVlakno.start();
            priznakVlakna=true;
        } catch (IOException a) {
            typHrace=false;
            jTextPane1.setText("Chyba spojeni. Mon dvody jsou patn zadan IP adresa nebo nedostupn s");
            
            
        }
        jDialog2.setVisible(false);
        ok.setVisible(false);
        text1.setVisible(false);
        
    }
    
    public void pripojitDialog(){
        ok2.setVisible(false);
        popisek.setText("");
        ip1.setVisible(false);
        ip2.setVisible(false);
        ip3.setVisible(false);
        ip4.setVisible(false);
        ok.setVisible(true);
        jDialog2.setTitle("Pripojit - Zadej port");
        
        jDialog2.setVisible(true);
        //  ok2.setVisible(true);
        text1.setVisible(true);
        jPanel1.add(ok);
        popisek.setText("Zadej port a stiskni OK");
        text1.setPreferredSize(new Dimension(100,20));
        text1.setMinimumSize(new Dimension(100,20));
        text1.setMaximumSize(new Dimension(100,20));
        jPanel1.add(text1);
        
    }
    /**
     * Spusti nove vlakno ServerThread. To obsluhuje server.
     */
    public void vytvoritPripojit(){
        
        priznakOdpojeni=false;
        ipAdresa=ip1.getText()+"."+ip2.getText()+"."+ip3.getText()+"."+ip4.getText();
        try{
            pole[0][0].reset(pole);
            
        } catch (MalformedURLException e) {
            jTextPane1.setText("CHYBA: Obrazky nenalezeny.");
        }
        text1.setVisible(true);
        ok.setVisible(true);
        if(jizPripojen){
            try{
                
                socket.close();
            } catch(IOException a){
                
                jTextPane1.setText("Chyba spojen, nelze uzavt stvajc spojen");
            }
        }
        
        s=new ServerP(port, this);
        s.start();
        
        try {
            socket = new Socket(ipAdresa, port);
            jizPripojen=true;
            vstup = new DataInputStream(socket.getInputStream());
            vystup = new DataOutputStream(socket.getOutputStream());
            vystupniVlakno = new Thread(this);
            vystupniVlakno.setDaemon(true);
            vystupniVlakno.start();
            priznakVlakna=true;
            priznakServeru=true;
        } catch (IOException a) {
            try{
                socket.close();} catch(IOException d){
                    jTextPane1.setText("Nepodarilo se uvolnit port, stiskni F5 a zvol jiny.");
                    
                }catch(NullPointerException xs){
                    jTextPane1.setText(xs.getMessage());
                    
                }
            
            jTextPane1.setText("Chyba spojeni. Mon dvody jsou patn zadan IP adresa nebo nedostupn s");
            typHrace=true;
        }
        jDialog2.setVisible(false);
        ok.setVisible(false);
        text1.setVisible(false);
    }
    public void vytvoritDialog2(){
        // je ze mne klient
        text1.setVisible(false);
        jDialog2.setTitle("Port "+port);
        popisek.setText("Zadej IP adresu. Do kadho pole zadej trojici cisel a stiskni OK");
        ip1.setVisible(true);
        ip2.setVisible(true);
        ip3.setVisible(true);
        ip4.setVisible(true);
        if(typHrace){
            // je server
            jPanel1.add(ok3);
            ok3.setVisible(true);
        }else{
            ok4.setVisible(true);
            jPanel1.add(ok4);
        }
    }
    public void vytvoritDialog(){
        ok2.setVisible(false);
        popisek.setText("");
        ip1.setVisible(false);
        ip2.setVisible(false);
        ip3.setVisible(false);
        ip4.setVisible(false);
        ok3.setVisible(false);
        
        jDialog2.setTitle("Vytvorit a pripojit - Zadej port");
        
        ok.setVisible(true);
        text1.setVisible(true);
        jDialog2.setVisible(true);
        
        popisek.setText("Zadej do  pole port a stiskni OK");
        text1.setPreferredSize(new Dimension(100,20));
        text1.setMinimumSize(new Dimension(100,20));
        text1.setMaximumSize(new Dimension(100,20));
        jPanel1.add(text1);
        
    }
    public void kontrolaPortu(){
        
        try{
            pole[0][0].reset(pole);
            priznakOdpojeni=false;
        } catch(MalformedURLException a){
            jTextPane1.setText("Obrazky nenalezeny");
        }
        try{
            port=Integer.valueOf(text1.getText());
            ok.setVisible(false);
            vytvoritDialog2();
        } catch(NumberFormatException q){
            vytvoritDialog();
            popisek.setText(" NEZADAL JSI PLATNY FORMAT CISLA");
        }
    }
    
    public void run(){
        try {
            cisloHrace=vstup.readInt();
            // precte, jake ma hrac cislo - znacku, 0 odpovida X
            jTextPane1.setText( "Jsi hrac " + cisloHrace);
            if(cisloHrace==0){
                aktualHrac=0;
            }else{
                aktualHrac=1;
            }
            
        } catch (Exception i) {
            
            jTextPane1.setText("Chyba spojeni");
            try{
                pole[0][0].reset(pole);
            }catch(MalformedURLException a){
                jTextPane1.setText("Obrazky nenalezeny");
            }
        }
        while (true){
            try {
                // precte zpravu ze vstupu a provede ji
                String textUTF= vstup.readUTF();
                prijmi(textUTF);
                
            } catch (Exception o ) {
                jTextPane1.setText("Protihrac prerusil spojeni. ");
                try{
                    pole[0][0].reset(pole);
                }catch(MalformedURLException a){
                    jTextPane1.setText("Obrazky nenalezeny");
                }
                
                
            }
        }
    }
    /**
     * Zpracuje text ze serveru. Podle obsahu daneho stringu se pak provede tato metoda.
     * @param text Text precteny ze serveru.
     */
    public void prijmi(String text) {
        
        if(!priznakOdpojeni){
            if (text.equals("Vyhral")){
                jTextPane1.setText(text+" jsi, na tahu je protihrac");
                try{
                    pole[0][0].reset(pole);
                    priznakOdpojeni=false;
                    return;
                } catch(MalformedURLException a){
                    jTextPane1.setText("Obrazky nenalezeny");
                }
            } else if(text.equals("Remiza")){
                jTextPane1.setText("Remiza");
                try{
                    pole[0][0].reset(pole);
                    priznakOdpojeni=false;
                } catch(MalformedURLException a){
                    jTextPane1.setText("Obrazky nenalezeny");
                }
            } else if (text.equals("Vzdal jsi hru")){
                jTextPane1.setText(text+", protihrac je na tahu");
                
                try{
                    pole[0][0].reset(pole);
                    priznakOdpojeni=false;
                } catch (MalformedURLException e) {
                    jTextPane1.setText("CHYBA: Obrazky nenalezeny.");
                }
            }
            
            else if(text.equals("Ceka se na dalsiho hrace")){
                jDialog2.setVisible(true);
                jDialog2.setMinimumSize(new Dimension(300,160));
                jDialog2.setPreferredSize(new Dimension(300,160));
                jDialog2.setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
                popisek.setText("Ceka se na druheho hrace, cekejte a nic nedelejte. Jakmile se druhy hrac pripoji,toto okno se zavre");
                
                ok3.setVisible(false);
                ip1.setVisible(false);
                ip2.setVisible(false);
                ip3.setVisible(false);
                ip4.setVisible(false);
                jDialog2.add(popisek);
                popisek.setVisible(true);
            } else if (text.equals("V poradku")) {
// jestlize byl tah v poradku, provede tahnuto
                novaHra.setEnabled(false);
                SwingUtilities.invokeLater(new Runnable() {
                    public void run(){
                        try{
                            currentButton.tahnuto(cisloHrace);} catch(MalformedURLException a){
                                jTextPane1.setText("Obrazky nenalezeny");
                            }
                    }
                }
                );
            } else if ( text.equals("Jiz pouzite")) {
                // jestlize tlacitko je jiz pouzite
                jTextPane1.setText(text);
                aktualHrac=0;
            }    else if (text.equals("Ted")) {
                ready=true;
                novaHra.setEnabled(true);
                // znamena, ze protihrac hral, musi se pole oznacit
                try {
                    final int location = vstup.readInt();
                    SwingUtilities.invokeLater(
                            new Runnable() {
                        public void run() {
                            int asi=(Integer)location/rozmer;
                            int asii=(location % rozmer);
                            if(location==(rozmer*rozmer+1)){
                                jTextPane1.setText("Protihrac vzdal, jsi na tahu");
                                try{
                                    pole[0][0].reset(pole);
                                    priznakOdpojeni=false;
                                }catch (MalformedURLException e) {
                                    jTextPane1.setText("CHYBA: Obrazky nenalezeny.");
                                }
                                
                            }
                            if(cisloHrace==0 && location!=(rozmer*rozmer+1)){
                                
                                try{
                                    pole[asi][asii].tahnuto(1);
                                } catch(MalformedURLException a){
                                    jTextPane1.setText("CHYBA: Obrazky nenalezeny.");
                                }
                                if(pole[0][0].remiza(pole)){
                                    jTextPane1.setText("Remiza");
                                    try{
                                        pole[0][0].reset(pole);
                                        priznakOdpojeni=false;
                                    } catch (MalformedURLException e) {
                                        jTextPane1.setText("CHYBA: Obrazky nenalezeny.");
                                    }
                                }
                                if(pole[asi][asii].vyhodnoceni(1,pole)) {
                                    jTextPane1.setText("Protihrac vyhral, jsi na tahu");
                                    try{
                                        pole[0][0].reset(pole);
                                        priznakOdpojeni=false;
                                    } catch (MalformedURLException e) {
                                        jTextPane1.setText("CHYBA: Obrazky nenalezeny.");
                                    }
                                }
                            }else if(cisloHrace==1 && location!=(rozmer*rozmer+1)){
                                try{
                                    pole[asi][asii].tahnuto(0);} catch(MalformedURLException a){
                                        jTextPane1.setText("CHYBA: Obrazky nenalezeny.");
                                    }
                                if(pole[0][0].remiza(pole)){
                                    jTextPane1.setText("Remiza");
                                    try{
                                        pole[0][0].reset(pole);
                                        priznakOdpojeni=false;
                                    } catch (MalformedURLException e) {
                                        jTextPane1.setText("CHYBA: Obrazky nenalezeny.");
                                    }
                                }
                                if(pole[asi][asii].vyhodnoceni(0,pole)) {
                                    jTextPane1.setText("Protihrac vyhral, jsi na tahu");
                                    try{
                                        pole[0][0].reset(pole);
                                        priznakOdpojeni=false;
                                    } catch (MalformedURLException e) {
                                        jTextPane1.setText("CHYBA: Obrazky nenalezeny.");
                                    }
                                }
                            }
                            
                        }
                    }
                    );
                    aktualHrac=0;
                } catch (Exception a) {
                    priznakOdpojeni=true;
                    try{
                        pole[0][0].reset(pole);
                    }catch(MalformedURLException h){
                        jTextPane1.setText("Nenalezeny obrazky");
                    }
                    jTextPane1.setText(a.getMessage());
                }
            } else {
                ready=true;
                novaHra.setEnabled(true);
                jDialog2.setVisible(false);
                
            }
        }
    }
    /**
     * Odesle tah hrace. Je - li hrac na rade, pak odesle tah (poradi stisknuteho tlacitka)
     *@param poradi Poradi prvku GrafickyButton v poli
     */
    public void odeslatTah(int poradi) {
        jTextPane1.setText("");
        if (aktualHrac==0 && !priznakOdpojeni && ready) {
            try {
                vystup.writeInt(poradi);
                aktualHrac= 1;
            } catch (Exception a) {
                priznakOdpojeni=true;
                jTextPane1.setText("Protihrac prerusil spojeni");
                try{
                    pole[0][0].reset(pole);
                }catch(MalformedURLException h){
                    jTextPane1.setText("Nenalezene obrazky");
                }
            }
        }
    }
    public void stop(){
        
        
    }
    public void start(){
        ok2.setVisible(true);
        jDialog2.setVisible(true);
        popisek.setText("Vitejte ve hre piskvorky. Pro hru po siti stisknete Vytvorit nebo Pripojit");
    }
    
}
