/*
 * GrafickyButton.java
 *
 * Created on 7. duben 2007, 15:55
 */
package GrafickeTridy;


import DatoveTridy.*;
import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.awt.event.*;
import java.net.*;
/**
 *
 * @author Vladimr ha
 */

public class GrafickyButton extends DatoveTridy.DatButton{
    private URL codeBase;
    public  int rozmer=15;
    private int vlastnik;
    private JButton tlacitko;
    private int umisteniX;
    private int umisteniY;
    private boolean pouzito;
    public int vysledek1;
    public int vysledek2;
    public int vysledek3;
    public int vysledek4;
    private ImageIcon [] ikonky=new ImageIcon[2];
    
    /** Vytvori objekt tridy GrafickyButton. Tento objekt predstavuje jedno herni tlacitko ve hre. Promenne tridy jsou:
     * @param y ktery hrac vlastni tlacitko, cili na nej kliknul a udelal jsou znaku X/O
     * @param z na kterem sloupci je dany GrafickyButton v poli GrafickyButtonu
     * @param x na kterem radku je dany GrafickyButton v poli GrafickyButtonu
     *  @param s znaci, jestli bylo na dany GrafickyButton jiz zahrano
     */
    
    public GrafickyButton(int y, int x, int z, boolean s, URL codebase) {
        super(y,x,z,s);
        this.vlastnik=y;
        this.tlacitko=new javax.swing.JButton();
        this.umisteniY=z;
        this.umisteniX=x;
        this.pouzito=s;
        this.codeBase = codebase;
       
                
    }    

    /** Vrati JButton  - tlacitko, daneho objektu typu Button
     * @return <code> this.tlacitko</code>
     */
    public JButton getButton(){
        return this.tlacitko;
    }
    public void removeButton(){
        this.tlacitko=null;
    }

    /** Vykona se pri stisku tlacitka. V zavislosti na parametru a typu integer nastavi u GrafickyButton jeho promenne na prislusne hodnoty
     * @param a integer a reprezentuje hrace, ktery tahnul
     */
    public void tahnuto(int a) throws MalformedURLException{
        if(a==0){
            this.setVlastnik(0);
            this.setPouzito(true);
            this.getButton().setIcon(new javax.swing.ImageIcon(new URL(codeBase,"obrazky"+File.separator+"x.gif")));
      
        } else{
            this.setVlastnik(1);
            this.setPouzito(true);
            this.getButton().setIcon(new javax.swing.ImageIcon(new URL(codeBase,"obrazky"+File.separator+"o.gif")));
        }
        
    }
    /** Vyhodnoti tah. Metoda vyhodnoceni pracuje s objekty tridy Vyhodnoceni, ktere vraci metody <code>vyhodnoceniRadku, vyhodnoceniSloupce, vyhodnoceniDiagonaly1
     *   a vyhodnoceniDiagonaly2</code>. Ty vraceji tyto objekty s parametry, ktere zavisi na uspesnosti tahu hrace (jestli vyhral). Je - li pak v nejakem vyhodnoceni1-4
     *  nastavena promenna vitezstvi na true, program reaguje a metoda vyhodnoceni vrati true, jinak false.
     * @param aktual cislo hrace, typ integer
     * @param pole 2-rozmerne pole prvku typu GrafickyButton
     *@return  vraci, zda byl hracuv tah vitezny
     */


    /** Nastavi vsechny instance tridy Button na puvodni hodnoty
     * @param pole Dvourozmerne pole objektu tridy GrafickyButton
     */
    public void reset(GrafickyButton[][] pole) throws MalformedURLException{
        for(int i=0;i<rozmer;i++){
            for(int y=0;y<rozmer;y++){
                pole[i][y].setPouzito(false);
                pole[i][y].setVlastnik(3);
                
                pole[i][y].getButton().setIcon(new javax.swing.ImageIcon(new URL(codeBase,"obrazky"+File.separator+"d.gif")));
                
                pole[i][y].getButton().setBackground(new Color(0,253,0));
            }
        }
    }

}
