/*
 * ServerP.java
 *
 * Created on 3. kvten 2007, 11:04
 *
 */
package Sit;

import DatoveTridy.DatButton;
import java.net.*;
import java.io.*;
import Sit.*;
import GrafickeTridy.*;



/**
 *
 * @author Vladimr ha
 */
public class ServerP extends Thread implements  Runnable {
    public int rozmer=15;
    private Client klient;
    public DatButton hraciPlocha[][]; //hraci plocha
    private Vlakno hraci[]=new Vlakno[2]; //vlakna
    private ServerSocket server;
    private int aktualniHrac;
    private int port;
    // hrac X ma 0, hrac O ma 1
    public void run(){
        this.prijmiHrace();
    }
    /** Creates a new instance of ServerP */
    public ServerP(int port, Client alpha) {
        this.port=port;
        this.klient=alpha;
        hraci=new Vlakno[2];
        hraciPlocha=new DatButton[rozmer][rozmer];
        aktualniHrac=0;
        // aktualni hrac ma cislo 0, cili vzdy zacina hrac X
        try {
            server = new ServerSocket(port, 2 );
        }      
        catch( IOException chyba ) {
       this.klient.jTextPane1.setText("Chyba spojeni, port je pravdepodobne jiz pouzivan");
        }


        for(int a=0;a<rozmer;a++){
            for(int t=0;t<rozmer;t++){
                final   DatButton q=new DatButton(3,a,t,false);
                hraciPlocha[a][t]=q;
            }
        }
        // vytvori hraci pole Buttonu
    }
    /** Metoda zjistiViteze zjisti, zda hrac vyhral. Parametr poradi reprezentuje poradi daneho DatButtonu v poli hraciPlocha, player pak cislo hrace, ktery hral.
     * V tele metody se zavola metoda vyhodnoceni na objekt tridy DatButton. Ten vraci boolean hodnotu, zda byl dany tah vitezny.
     * @param poradi poradi DatButtonu v poli DatButtonu
     * @param player cislo hrace
     *@return zda byl tah vitezny
     */
   public synchronized boolean zjistiViteze(int poradi, int player){
      
        int asi=(Integer)poradi/rozmer;
        int asii=(poradi % rozmer);
        return hraciPlocha[asi][asii].vyhodnoceni(player, hraciPlocha);
    }
        /** Metoda zkontroluj zjisti, zda byl hracuv tah validni (na neobsazene pole). Parametr poradi reprezentuje poradi daneho DatButtonu v poli hraciPlocha, player pak cislo hrace, ktery hral.
         * Jestlize byl tah v poradku, pak se provede pomoci vlakna tridy Vlakno
         * @param poradi poradi DatButtonu v poli DatButtonu
         * @param player cislo hrace
         *@return zhodnoceni celeho tahu
         **/
    public synchronized boolean zkontroluj(int poradi, int player ) throws InterruptedException{
        /**
         * kriticka sekce, vlakna zde nemohou pracovat paralelne, ale seriove
         * pomoci "synchronized" se aktivoval monitor objektu, diky tomu jsou metody neprerusitelne, cili predavani rizeni nemuze nastat. Pote, co
         * objekt ma aktivovany monitor, nemuze zadne jine vlakno provadet akci s touto metodou.
         *  Zajisti, aby nemohli hrat oba hraci najednou
         */
        while ( player != aktualniHrac ) {
            // dokavad je player jiny nez ten soucasny, tak cekej
            // wait for turn
                wait();
        }
        int asi=(Integer)poradi/rozmer;
        int asii=(poradi % rozmer);
      if(this.jeKonec(poradi)){
          if(aktualniHrac==0){
                aktualniHrac=1;
            }else{
                aktualniHrac=0;
            }
           hraci[aktualniHrac].tah(poradi); //bylo tazeno
            notify();
            //  umozni, aby hral druhy hrac, povoli akci dalsimu vlaknu
            return true;
        }
        if ( !hraciPlocha[asi][asii].getPouzito() ) {
            try{
            hraciPlocha[asi][asii].tahnuto(aktualniHrac);}
            catch(MalformedURLException df){
            
            
            }
            // zmeni aktualniho hrace na toho druheho, pouze pokud neni pole jiz pouzite
            if(aktualniHrac==0){
                aktualniHrac=1;
            }else{
                aktualniHrac=0;
            }
  
            hraci[aktualniHrac].tah(poradi); //bylo tazeno
            notify();
            //  umozni, aby hral druhy hrac, povoli akci dalsimu vlaknu
            return true;
        } else
            return false;
    }
    /**
     * Prijme hrace. Vyvola nove vlakno s parametry socket (cili server.accept()), cislo hrace a objekt ServerP
     */
    public void prijmiHrace(){
        // ceka na 2 hrace, kteri se pripoji
        try{
            hraci[0]=new Vlakno(server.accept(), 0, this, this.klient);
            hraci[0].start();
            hraci[1]=new Vlakno(server.accept(), 1, this,this.klient);
            hraci[1].start();
            // vytvori nove instance tridy Vlakno
        } catch(IOException a){
            System.exit(-1);
        }
        catch(NullPointerException a){
        this.klient.jTextPane1.setText("Chyba spojeni, port je pravdepodobne jiz obsazen, rada : Zmente port");
        
        }

try{
        synchronized ( hraci[ 0 ] ) {
            hraci[ 0 ].setSuspended( false );
            hraci[ 0 ].notify();
        }}catch(NullPointerException v){
        this.klient.jTextPane1.setText("Port je obsazen, stiskni F5 a zvol jiny");
        }
    }
        public synchronized boolean jeKonec(int poradi){
    if(poradi==(rozmer*rozmer+1))return true;
    else return false;
    
    }
}
